<?php declare(strict_types=1);

namespace Rvvup\Payments\Actions;

use Rvvup\Payments\Service\SessionManager;

/**
 * Monitor the cart contents for changes so the Express process is aborted if any products are changed
 */
class ExpressCheckoutCartModification
{
    public function __construct()
    {
        add_filter("woocommerce_update_cart_action_cart_updated", [$this, "clearExpressSession"]);
        add_action("woocommerce_ajax_added_to_cart", [$this, "clearExpressSession"]);
        add_action("woocommerce_remove_cart_item", [$this, "clearExpressSession"]);
    }

    /**
     * @return void
     */
    public function clearExpressSession()
    {
        SessionManager::getInstance()->unsetRvvupExpressOrder();
    }
}
