<?php

declare(strict_types=1);

namespace Rvvup\Payments\Actions;

use Rvvup\Payments\Service\SessionManager;

class ExpressCheckoutLoad
{
    public function __construct()
    {
        add_filter("woocommerce_available_payment_gateways", [$this, "limitPaymentMethods"], 10, 1);
    }

    /**
     * if on customer session and Rvvup Express Order is set, filter payment methods to the one selected.
     *
     * @param $methods
     * @return array|mixed
     */
    public function limitPaymentMethods($methods)
    {
        if (is_admin()) {
            return $methods;
        }

        $rvvupExpressOrder = SessionManager::getInstance()->getRvvupExpressOrder();

        if (
            !is_array($rvvupExpressOrder) ||
            !isset($rvvupExpressOrder["id"], $rvvupExpressOrder["payment_method_code"])
        ) {
            return $methods;
        }

        /**
         * Handle Rvvup express payments gateway filtering
         */
        foreach ($methods as $k => $v) {
            if ("rvvup_gateway_" . $rvvupExpressOrder["payment_method_code"] === mb_strtolower($k)) {
                /** \Rvvup\Payments\Gateway\Dynamic $v */
                return [$k => $v];
            }
        }

        return $methods;
    }
}
