<?php

namespace Rvvup\Payments\Contract\Service;

use Rvvup\Payments\Gateway\Dynamic;

interface GatewaySettingsManagerInterface
{
    /**
     * Check whether Rvvup is enabled.
     *
     * @return bool
     */
    public function isEnabled(): bool;

    /**
     * Get the merchant ID.
     *
     * @return string|null
     */
    public function getMerchantId(): ?string;

    /**
     * Get the enabled product types.
     *
     * @return array
     */
    public function getEnabledProductTypes(): array;

    /**
     * Get the api data settings loaded in the Gateway.
     *
     * @param \Rvvup\Payments\Gateway\Dynamic $gateway
     * @param string $path
     * @return mixed|null
     */
    public function getApiConfig(Dynamic $gateway, string $path);

    /**
     * Get the modal position for mobile layout.
     *
     * @return string|null
     */
    public function getMobileModalPosition(): ?string;

    /**
     * Check whether ClearPay Messaging should be displayed (enabled display).
     *
     * Defaults to true.
     *
     * @param string $area
     * @return bool
     */
    public function shouldShowClearPayMessaging(string $area): bool;

    /**
     * Get ClearPay theme.
     *
     * Defaults to Black on Mint
     *
     * @param string $area
     * @return string
     */
    public function getClearPayTheme(string $area): string;

    /**
     * Is Debug mode enabled?
     *
     * @return bool
     */
    public function isDebugEnabled(): bool;
}
