<?php declare(strict_types=1);

namespace Rvvup\Payments\Controller;
use Rvvup\Payments\Service\GatewayLoader;
use Rvvup\Payments\Service\LoggerManager;

class PayOrderEndpoint
{
    const ENDPOINT = "rvvup-pay-order";

    public static function execute()
    {
        $nonce_value = wc_get_var($_REQUEST["woocommerce-pay-nonce"], wc_get_var($_REQUEST["_wpnonce"], ""));
        $logger = LoggerManager::getInstance();

        $orderId = sanitize_text_field($_POST["order_id"]);
        $metadata = [];
        $metadata["order_id"] = $orderId;

        if (!wp_verify_nonce($nonce_value, "woocommerce-pay")) {
            $logger->error("Pay order failed with missing nonce value, order id", $metadata);
            wp_send_json_error("Cannot process this request");
        }

        $wcOrder = wc_get_order($orderId);
        if (!$wcOrder || !$wcOrder->needs_payment()) {
            $logger->error("Pay order failed with order do not exist, id", $metadata);
            wp_send_json_error("Order Not Found");
        }

        $paymentMethod = sanitize_text_field($_POST["payment_method"]);
        $rvvupMethodStartsWith = "rvvup_gateway_";
        if (substr($paymentMethod, 0, strlen($rvvupMethodStartsWith)) !== $rvvupMethodStartsWith) {
            $logger->error("Pay order failed with non-rvvup method, order id", $metadata);
            wp_send_json_error("Payment Method cannot use this request");
        }

        new GatewayLoader();

        $available_gateways = WC()->payment_gateways->get_available_payment_gateways();
        if (!isset($available_gateways[$paymentMethod])) {
            $logger->error("Pay order failed with unavailable method, order id", $metadata);
            wp_send_json_error("Invalid Payment Method");
        }

        $result = $available_gateways[$paymentMethod]->process_payment($orderId);

        if (isset($result["result"])) {
            $result["order_id"] = $orderId;
            wp_send_json($result);
        }
    }
}
