<?php

declare(strict_types=1);

namespace Rvvup\Payments\Controller;

use Exception;
use Rvvup\Payments\Service\LoggerManager;
use Rvvup\Payments\Service\VoidOrder;
use Rvvup\Payments\Sdk\Exceptions\ApiError;

class VoidEndpoint
{
    /**
     * @return void
     * @throws Exception
     */
    public static function execute()
    {
        $order = wc_get_order($_POST["id"]);

        try {
            VoidOrder::voidOrder($order);
        } catch (\ErrorException | ApiError $exception) {
            LoggerManager::getInstance()->error("Void order failed with message:" . $exception->getMessage(), [
                "order_id" => $order->get_id(),
            ]);
            wp_send_json(["result" => "failure", "error" => $exception->getMessage()]);
        }
        wp_send_json(["result" => "success"]);
    }
}
