<?php

namespace Rvvup\Payments\Facade;

use WC_Tax;

/**
 * Facade for WooCommerce Tax functionality
 *
 * This facade provides a testable wrapper around WC_Tax static methods,
 * enabling dependency injection and easier unit testing.
 */
class WCTaxFacade
{
    /**
     * @var WCTaxFacade|null
     */
    private static $instance = null;

    /**
     * Private constructor to prevent direct instantiation
     */
    private function __construct()
    {
        // Private constructor
    }

    /**
     * Get the singleton instance
     *
     * @return WCTaxFacade
     */
    public static function getInstance(): WCTaxFacade
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * @see wc_tax_enabled()
     */
    public function isTaxEnabled(): bool
    {
        return wc_tax_enabled();
    }

    /**
     * @see WC_Tax::find_rates
     */
    public function findRates(array $request): array
    {
        return WC_Tax::find_rates($request);
    }
}
