<?php declare(strict_types=1);

namespace Rvvup\Payments\Gateway;

class Fallback extends Rvvup
{
    /**
     * Gateway property constants.
     */
    public const ID = "rvvup_gateway_fallback";

    public function __construct()
    {
        $this->id = self::ID;
        parent::__construct();
        add_action("woocommerce_update_options_payment_gateways_" . $this->id, [$this, "process_admin_options"]);
        $this->title = __("Rvvup (Unavailable)", "rvvup-for-woocommerce");
        $this->description = __("Sorry, Rvvup payments are currently unavailable", "rvvup-for-woocommerce");
    }

    public function validate_fields()
    {
        wc_add_notice(__("Sorry, Rvvup payments are currently unavailable", "rvvup-for-woocommerce"), "error");
        return false;
    }

    public function is_available()
    {
        return (bool) $this->settings["show_if_unavailable"];
    }
}
