<?php
declare(strict_types=1);

namespace Rvvup\Payments\Gateway;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\Blocks\Payments\PaymentContext;
use Automattic\WooCommerce\Blocks\Payments\PaymentResult;
use Rvvup\Payments\Model\AssetLoader;

defined("ABSPATH") || exit();

final class Rvvup_WC_Blocks_Support extends AbstractPaymentMethodType
{
    public function __construct()
    {
        $this->name = "rvvup";
    }

    public function initialize()
    {
    }

    public function get_payment_method_script_handles()
    {
        return AssetLoader::loadAssetsForBlocks();
    }

    public function get_payment_method_script_handles_for_admin()
    {
        return [];
    }
}
