<?php declare(strict_types=1);

namespace Rvvup\Payments\Lib;

class Versions
{
    public static function getPluginVersion(): string
    {
        try {
            return function_exists("get_file_data")
                ? get_file_data(RVVUP_PLUGIN_FILE, ["Version" => "Version"], "plugin")["Version"]
                : "nofiledata";
        } catch (\Exception $e) {
            return "noversion";
        }
    }

    public static function getUserAgent(): string
    {
        $environmentVersions = self::getEnvironmentVersions();

        $parts = [
            "RvvupWordpressPayments/" . $environmentVersions["rvvp_plugin_version"],
            "WooCommerce/" . $environmentVersions["woocommerce_version"],
            "WordPress/" . $environmentVersions["wordpress_version"],
            "PHP/" . $environmentVersions["php_version"],
        ];
        return implode("; ", $parts);
    }

    public static function getEnvironmentVersions(): array
    {
        global $wp_version;

        return [
            "rvvp_plugin_version" => self::getPluginVersion(),
            "php_version" => phpversion(),
            "wordpress_version" => $wp_version ?? "unknown",
            "woocommerce_version" => defined("WC_VERSION") ? WC_VERSION : "unknown",
        ];
    }
}
