<?php declare(strict_types=1);

namespace Rvvup\Payments\Model;

class SimpleJWT
{
    /**
     * @param string $jwt
     * @return false|\stdClass
     */
    public static function getPayload(string $jwt)
    {
        if (!self::isValid($jwt)) {
            return false;
        }
        $parts = explode(".", $jwt);
        $payload = base64_decode($parts[1]);
        return json_decode($payload);
    }

    /**
     * @param string $jwt
     * @return bool
     */
    public static function isValid(string $jwt): bool
    {
        $parts = explode(".", $jwt);
        if (count($parts) !== 3) {
            return false;
        }
        $header = base64_decode($parts[0]);
        $payload = base64_decode($parts[1]);
        if (false === $header || false === $payload) {
            return false;
        }
        return true;
    }
}
