<?php
declare(strict_types=1);

namespace Rvvup\Payments\Sdk\Rest\Api;

use Rvvup\Payments\Sdk\Exceptions\NetworkException;
use Rvvup\Payments\Sdk\Rest\RestApi;

class ShipmentTrackings
{
    /**
     * @var RestApi
     */
    private $api;

    public function __construct(RestApi $api)
    {
        $this->api = $api;
    }

    /**
     * @throws NetworkException
     */
    public function create(string $paymentSessionId, $data): array
    {
        return $this->api->doRequest("POST", "/payment-sessions/" . $paymentSessionId . "/shipment-tracking", $data);
    }
}
