<?php

namespace Rvvup\Payments\Sdk\Rest;

use Rvvup\Payments\Sdk\Curl;
use Rvvup\Payments\Sdk\Exceptions\ApiError;
use Rvvup\Payments\Sdk\Exceptions\NetworkException;

class RestApi
{
    private $clientOptions;
    private $adapter;
    private $bearerToken;

    public function __construct(string $bearerToken, RvvupClientOptions $options)
    {
        $this->adapter = new Curl();
        $this->bearerToken = $bearerToken;
        $this->clientOptions = $options;
    }

    /**
     * @throws NetworkException
     * @throws \Exception
     */
    function doRequest($method, $endpoint, $data)
    {
        $options = [
            "json" => $data,
            "headers" => [
                "Content-Type: application/json; charset=utf-8",
                "Accept: application/json",
                "Authorization: Bearer " . $this->bearerToken,
            ],
            "user_agent" => $this->clientOptions->getUserAgent(),
        ];

        $endpoint = $this->clientOptions->getBaseUrl() . $endpoint;

        $response = $this->adapter->request($method, $endpoint, $options);
        $body = $response->body;
        $responseCode = $response->response_code;
        if ($responseCode >= 200 && $responseCode < 300) {
            return json_decode($body, true);
        }
        $error = json_decode($body, true);
        if (isset($error["errorMessage"])) {
            throw new ApiError($error["errorCode"] ?? "", $error["errorMessage"]);
        }

        if ($responseCode >= 500 && $responseCode < 600) {
            throw new NetworkException(
                "There was a network error returned via the API. Please use the same idempotency if you retry."
            );
        }

        throw new \Exception("Unexpected HTTP response code received: " . $responseCode);
    }
}
