<?php
declare(strict_types=1);

namespace Rvvup\Payments\Sdk\Rest;

use Exception;
use Rvvup\Payments\Sdk\Rest\Api\ShipmentTrackings;

class RvvupClient
{
    private $api;

    /**
     * $var ShipmentTrackings
     */
    private $shipmentTrackings;

    /**
     * @throws Exception
     */
    public function __construct(string $bearerToken, ?RvvupClientOptions $options)
    {
        $jwt = $this->decodeJwt($bearerToken);
        if ($jwt == null) {
            throw new \Exception("Invalid auth token");
        }
        $options = $options ?? new RvvupClientOptions();
        if ($options->getBaseUrl() == null) {
            $options->setBaseUrl(str_replace("/graphql", "/api/2024-03-01/" . $jwt["merchantId"], $jwt["aud"]));
        }
        if ($options->getMerchantId() == null) {
            $options->setMerchantId($jwt["merchantId"]);
        }
        $this->api = new RestApi($bearerToken, $options);

        $this->shipmentTrackings = new ShipmentTrackings($this->api);
    }

    /**
     * @return ShipmentTrackings
     */
    public function shipmentTrackings(): ShipmentTrackings
    {
        return $this->shipmentTrackings;
    }

    private function decodeJwt(string $jwt): ?array
    {
        $parts = explode(".", $jwt);
        if (!$parts || count($parts) <= 1) {
            return null;
        }
        $payload = $parts[1];
        if ($payload == null) {
            return null;
        }

        return json_decode(base64_decode($payload), true);
    }
}
