<?php

declare(strict_types=1);

namespace Rvvup\Payments\Service;

use Rvvup\Payments\Gateway\Method;

class Cache
{
    const RVVUP = "rvvup_";

    /**
     * @param string $orderId
     * @param string $type
     * @param string $status
     * @return mixed
     */
    public function get(string $orderId, string $type, string $status)
    {
        $identifier = self::RVVUP . $orderId . "_" . $type . "_" . $status;

        return wp_cache_get($identifier);
    }

    /**
     * @param string $orderId
     * @param string $type
     * @param string $value
     * @param string $status
     * @return void
     */
    public function set(string $orderId, string $type, string $value, string $status): void
    {
        $identifier = self::RVVUP . $orderId . "_" . $type . "_" . $status;
        wp_cache_set($identifier, $value, "", strtotime("15 mins"));
    }

    /**
     * Clear void and refund cache
     * @param string $orderId
     * @return void
     */
    public function clear(string $orderId, string $status): void
    {
        $refundIdentifier = self::RVVUP . $orderId . "_refund_" . $status;
        $voidIdentifier = self::RVVUP . $orderId . "_void_" . $status;
        wp_cache_delete($refundIdentifier);
        wp_cache_delete($voidIdentifier);
    }
}
