<?php declare(strict_types=1);

namespace Rvvup\Payments\Service;

class ClearpayThresholdManager
{
    /** @var self */
    private static $instance;
    /** @var array|null */
    private $threshold;

    const METHOD = "CLEARPAY";

    /**
     * For this class we use the singleton pattern to avoid redundant DB I/O
     * @return static
     */
    public static function getInstance(): self
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @throws \Exception
     */
    private function __construct()
    {
        $this->init();
    }

    /**
     * @param string $price
     * @param string $currency
     * @return bool
     */
    public function get(string $price, string $currency): bool
    {
        $price = (float) $price;
        if ($this->threshold === null) {
            return true;
        }
        if (
            $this->threshold["currency"] === $currency &&
            $price <= $this->threshold["max"] &&
            $price >= $this->threshold["min"]
        ) {
            return true;
        }
        return false;
    }

    /**
     * @throws \Exception
     */
    private function init()
    {
        $methods = SdkProxy::getThresholds();
        if (array_key_exists("CLEARPAY", $methods)) {
            foreach ($methods["CLEARPAY"] as $currency) {
                $this->threshold = $currency;
            }
        }
    }
}
