<?php

declare(strict_types=1);

namespace Rvvup\Payments\Service;

use Exception;

class EventManager
{
    /**
     * @var self
     */
    private static $instance;

    /**
     * For this class we use the singleton pattern to avoid redundant DB I/O
     * @return static
     */
    public static function getInstance(): self
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @param string $reason
     * @return void
     */
    public function dispatchPluginDisabledEvent(string $reason): void
    {
        try {
            SdkProxy::createEvent("MERCHANT_PLUGIN_DEACTIVATED", $reason);
        } catch (Exception $ex) {
            $logger = LoggerManager::getInstance();

            $logger->error(
                "Exception thrown when sending plugin enabled API request with message: " . $ex->getMessage()
            );
        }
    }

    /**
     * @param string $reason
     * @return void
     */
    public function dispatchPluginEnabledEvent(string $reason): void
    {
        try {
            SdkProxy::createEvent("MERCHANT_PLUGIN_ACTIVATED", $reason);
        } catch (Exception $ex) {
            $logger = LoggerManager::getInstance();

            $logger->error(
                "Exception thrown when sending plugin enabled API request with message: " . $ex->getMessage()
            );
        }
    }
}
