<?php

declare(strict_types=1);

namespace Rvvup\Payments\Service;

if (!defined("ABSPATH")) {
    exit(); // Exit if accessed directly
}

use Rvvup\Payments\Model\PostTypes\RvvupRefund;

class PostTypesManager
{
    /**
     * @var self
     */
    private static $instance;

    /**
     * For this class we use the singleton pattern to avoid redundant DB I/O
     * @return static
     */
    public static function getInstance(): self
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @return void
     */
    public function init(): void
    {
        add_action("init", [$this, "registerRvvupRefunds"]);
    }

    /**
     * Register custom Rvvup Refund Post Type
     *
     * @return void
     */
    public function registerRvvupRefunds(): void
    {
        // No need to re-register if it is already done.
        if (!function_exists("wc_register_order_type") || post_type_exists(RvvupRefund::TYPE)) {
            return;
        }

        wc_register_order_type(
            RvvupRefund::TYPE,
            apply_filters("rvvup_register_post_type_" . RvvupRefund::TYPE, [
                "label" => __("Rvvup Refunds", "rvvup-for-woocommerce"),
                "capability_type" => "shop_order",
                "public" => false,
                "hierarchical" => false,
                "supports" => false,
                "exclude_from_orders_screen" => false,
                "add_order_meta_boxes" => false,
                "exclude_from_order_count" => true,
                "exclude_from_order_views" => false,
                "exclude_from_order_reports" => false,
                "exclude_from_order_sales_reports" => true,
                "class_name" => RvvupRefund::class,
                "rewrite" => false,
            ])
        );
    }
}
