<?php

declare(strict_types=1);

namespace Rvvup\Payments\Service;

use Exception;

class SessionManager
{
    /**
     * @var self
     */
    private static $instance;

    /**
     * For this class we use the singleton pattern to avoid redundant DB I/O
     * @return static
     */
    public static function getInstance(): self
    {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Set Rvvup Express Order data to the session.
     *
     * @param array $data
     * @return void
     */
    public function setRvvupExpressOrder(array $data): void
    {
        if (WC()->session === null) {
            return;
        }

        WC()->session->set("rvvup_express_order", $data);
    }

    /**
     * Unset Rvvup Express Order data from the session.
     *
     * @return void
     */
    public function unsetRvvupExpressOrder(): void
    {
        if (WC()->session === null) {
            return;
        }

        WC()->session->__unset("rvvup_express_order");
    }

    /**
     * Get Rvvup Express Order data from the session.
     *
     * @return array|string|null
     */
    public function getRvvupExpressOrder()
    {
        if (WC()->session === null) {
            return null;
        }

        return WC()->session->get("rvvup_express_order");
    }
}
