<?php

declare(strict_types=1);

namespace Rvvup\Payments\Service;

use Rvvup\Payments\Sdk\Exceptions\ApiError;
use WC_Order;

if (!defined("ABSPATH")) {
    exit();
}

class VoidOrder
{
    /**
     * @param WC_Order $order
     * @return void
     * @throws \Exception
     */
    public static function voidOrder(WC_Order $order): void
    {
        if (self::isVoidable($order)) {
            $id = $order->get_transaction_id();
            $orderData = SdkProxy::getOrder($id);
            SdkProxy::voidPayment($order, $orderData["payments"][0]["id"]);
            $order->update_status("cancelled", "Order was cancelled due to void operation through Rvvup.", false);
        }
    }

    /**
     * Check if order is voidable
     * @param WC_Order $order
     * @return bool
     */
    public static function isVoidable(WC_Order $order): bool
    {
        $paymentMethod = $order->get_payment_method();
        $isRvvupOrder = $paymentMethod && stripos($paymentMethod, "rvvup_gateway_") === 0;

        if ($isRvvupOrder && $order->get_transaction_id()) {
            try {
                return SdkProxy::isOrderVoidable($order);
            } catch (\Exception $ex) {
                return false;
            }
        }
        return false;
    }
}
