<?php

declare(strict_types=1);

namespace Rvvup\Payments\Traits;

if (!defined("ABSPATH")) {
    exit(); // Exit if accessed directly
}

trait EndpointTrait
{
    /**
     * Add error message and return result.
     *
     * @param string $message
     * @return void
     */
    private static function addNoticeAndFail(string $message)
    {
        wc_add_notice($message, "error");
        wp_send_json(["result" => "failure", "reload" => true]);
    }

    /**
     * Return Bad Request Response to the client.
     *
     * @return void
     */
    private static function returnBadRequestResponse(): void
    {
        status_header(400);
        die();
    }

    /**
     * Return Application/Server Error Response to the client.
     *
     * @return void
     */
    private static function returnApplicationErrorResponse(): void
    {
        status_header(500);
        die();
    }

    /**
     * Return Success Response to the client.
     *
     * @return void
     */
    private static function returnSuccessResponse(): void
    {
        status_header(200);
        die();
    }
}
