<?php

declare(strict_types=1);

namespace Rvvup\Payments\Traits;

use Automattic\WooCommerce\Utilities\OrderUtil;

if (!defined("ABSPATH")) {
    exit(); // Exit if accessed directly
}

trait MetaDataTrait
{
    /**
     * @param $orderId
     * @param string $key
     * @return mixed
     */
    protected function getMetaData($orderId, string $key)
    {
        if ($this->isCustomOrderTableEnabled()) {
            $order = wc_get_order($orderId);
            if ($order) {
                return $order->get_meta($key);
            }
        }
        return get_post_meta($orderId, $key, true);
    }
    /**
     * Check whether the payment method is the fallback Rvvup gateway.
     *
     * @param $orderId
     * @param string $key
     * @param string $metadata
     * @return void
     */
    protected function updateMetaData($orderId, string $key, string $metadata): void
    {
        if ($this->isCustomOrderTableEnabled()) {
            $order = wc_get_order($orderId);
            if ($order) {
                $order->update_meta_data($key, $metadata);
                $order->save();
            }
        } else {
            update_post_meta($orderId, $key, $metadata);
        }
    }

    protected function deleteMetaData($orderId, string $key): void
    {
        if ($this->isCustomOrderTableEnabled()) {
            $order = wc_get_order($orderId);
            $order->delete_meta_data($key);
            $order->save();
        } else {
            delete_post_meta($orderId, $key);
        }
    }

    /**
     * @return bool
     */
    private function isCustomOrderTableEnabled(): bool
    {
        if (class_exists(OrderUtil::class)) {
            if (OrderUtil::custom_orders_table_usage_is_enabled()) {
                return true;
            }
        }
        return false;
    }
}
