document.addEventListener("DOMContentLoaded", function () {
  var woocommerceRvvupGatewayJwt = document.getElementById("woocommerce_rvvup_gateway_jwt");

  if (woocommerceRvvupGatewayJwt !== null && woocommerceRvvupGatewayJwt.length > 0) {
    woocommerceRvvupGatewayJwt.addEventListener("change", function (event) {
      const parts = event.target.value.split(".");
      if (parts.length === 3) {
        const payload = atob(parts[1]);
        const json = JSON.parse(payload);
        if (json.hasOwnProperty("live")) {
          switch (json.live) {
            case true:
              setEnvMessage(event.target, "API key entered is for PRODUCTION", "updated");
              break;
            case false:
              setEnvMessage(event.target, "API key entered is for SANDBOX", "updated");
              break;
            default:
              setEnvMessage(event.target, "API key entered environment is UNKNOWN", "error");
          }
        } else {
          setEnvMessage(event.target, "API key entered environment is UNKNOWN", "error");
        }
      } else {
        setEnvMessage(event.target, "Value entered is not a valid API key", "error");
      }

      function setEnvMessage(element, message, type) {
        const existing = document.getElementById("rvvup_api_environment");
        if (existing) {
          existing.remove();
        }
        element.insertAdjacentHTML(
          "afterend",
          '<div id="rvvup_api_environment" class="' + type + '" style="width:370px">' + message + "</div>"
        );
      }
    });
  }

  /**
   *  Adding onclick to void button
   */
  jQuery(document).ready(function (e) {
    jQuery(".rvvup-void-button").on("click", function (e) {
      e.preventDefault();
      if (confirm("Are you sure you want to void this payment?")) {
        let id = jQuery(this).attr("id");
        jQuery.ajax({
          type: "POST",
          url: window.location.origin + "/wp-admin/admin-ajax.php?action=rvvup_void",
          data: { id: id },
          dataType: "json",
          success: function (e) {
            if ("success" === e.result) {
              window.location.reload();
            } else {
              if (e.error) {
                alert(e.error);
              }
            }
          },
          error: function (e) {
            alert("Sorry something went wrong");
          },
        });
      }
    });

    /**
     * Remove the delete refund action element from the admin order view if an associated Rvvup Refund is attached.
     * The Rvvup Refund will exist only if Refund is Pending or Successful
     */
    let cancelCrosses = jQuery("a.delete_refund");
    cancelCrosses.each(function () {
      let refundLine = jQuery(this).parents("tr.refund");

      if (refundLine.length === 1 && refundLine.find("p.rvvup-refund-item").length === 1) {
        cancelCrosses.remove();
      }
    });
  });
});
