/**
 * Is PDP button enabled for PayPal?
 *
 * @return {boolean}
 */
function rvvup_isPdpButtonEnabled() {
  let rvvup_parameters = typeof window.rvvup_parameters === "object" ? window.rvvup_parameters : {};

  return rvvup_parameters?.settings?.paypal?.product?.button?.enabled || false;
}

/**
 * Get the PayPal Button style.
 *
 * @return {{layout: (*|string), color: (*|string), shape: (*|string), tagline: (*|boolean), label: (*|string), height: *}}
 */
function rvvup_getPdpButtonStyle() {
  /* Default PDP fallback if rvvup_parameters object not set */
  if (typeof rvvup_parameters !== "object") {
    return {
      layout: "vertical",
      color: "gold",
      shape: "rect",
      label: "paypal",
      tagline: false,
    };
  }

  const layout = rvvup_parameters?.settings?.paypal?.product?.button?.layout?.value || "vertical";
  const color = rvvup_parameters?.settings?.paypal?.product?.button?.color?.value || "gold";
  const shape = rvvup_parameters?.settings?.paypal?.product?.button?.shape?.value || "rect";
  const label = rvvup_parameters?.settings?.paypal?.product?.button?.label?.value || "paypal";
  const tagline = rvvup_parameters?.settings?.paypal?.product?.button?.tagline || false;
  const size = rvvup_parameters?.settings?.paypal?.product?.button?.size || null;

  let style = {
    layout: layout,
    color: color,
    shape: shape,
    label: label,
    tagline: tagline,
  };

  if (size !== null) {
    style.height = size;
  }

  return style;
}

/**
 * Get the PayPal Button style.
 *
 * @return {{layout: (*|string), color: (*|string), shape: (*|string), tagline: (*|boolean), label: (*|string), height: *}}
 */
function rvvup_getCheckoutButtonStyle() {
  /* Default Checkout fallback if rvvup_parameters object not set */
  if (typeof rvvup_parameters !== "object") {
    return {
      layout: "vertical",
      color: "blue",
      shape: "rect",
      label: "paypal",
      tagline: false,
    };
  }

  const layout = rvvup_parameters?.settings?.paypal?.checkout?.button?.layout?.value || "vertical";
  const color = rvvup_parameters?.settings?.paypal?.checkout?.button?.color?.value || "blue";
  const shape = rvvup_parameters?.settings?.paypal?.checkout?.button?.shape?.value || "rect";
  const label = rvvup_parameters?.settings?.paypal?.checkout?.button?.label?.value || "paypal";
  const tagline = rvvup_parameters?.settings?.paypal?.checkout?.button?.tagline || false;
  const size = rvvup_parameters?.settings?.paypal?.checkout?.button?.size || null;

  let style = {
    layout: layout,
    color: color,
    shape: shape,
    label: label,
    tagline: tagline,
  };

  if (size !== null) {
    style.height = size;
  }

  return style;
}

/**
 * Show/Hide (toggle) paypal checkout pay later messaging container.
 *
 * @param {Boolean} show
 */
function rvvup_toggleCheckoutPayPalMessage(show = true) {
  let element = document.getElementById("checkout-messaging-rvvup_gateway_PAYPAL");

  if (element === null || element.length === 0) {
    return;
  }

  if (show === true && element.style.display === "none") {
    element.style.display = "block";
    return;
  }

  if (show === false && element.style.display === "block") {
    element.style.display = "none";
  }
}
